package app.firezone.synk.network;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;

import java.util.ArrayList;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.SlotAdapter;
import app.firezone.synk.network.databinding.ActivityMatchSlotsBinding;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.SlotItem;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class MatchSlotsActivity extends AppCompatActivity {

    ActivityMatchSlotsBinding binding;

    String gamename, teamType;
    long totalPlayer, matchId, entryFee;
    long userId;

    ArrayList<SlotItem> slotList;
    SlotAdapter adapter;

    private MyApi myApi;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityMatchSlotsBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        gamename = getIntent().getStringExtra("gamename");
        teamType = getIntent().getStringExtra("teamType");
        totalPlayer = getIntent().getLongExtra("totalPlayer", 0);
        entryFee = getIntent().getLongExtra("entryFee", 0);
        matchId = getIntent().getLongExtra("matchId", 0);

        userId = SharedPrefManager.getInstance(this).getUserId();
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        if (teamType.equalsIgnoreCase("Duo")) {
            binding.textB.setVisibility(View.VISIBLE);
        } else if (teamType.equalsIgnoreCase("Squad")) {
            binding.textB.setVisibility(View.VISIBLE);
            binding.textC.setVisibility(View.VISIBLE);
            binding.textD.setVisibility(View.VISIBLE);
        }

        binding.backArrow.setOnClickListener(v -> finish());

        loadSlotList();

        adapter = new SlotAdapter(this, slotList, teamType);
        binding.slotsRecycler.setLayoutManager(new LinearLayoutManager(this));
        binding.slotsRecycler.setAdapter(adapter);

        binding.nextBtn.setOnClickListener(v -> {
            ArrayList<String> selectedSlotNumbers = new ArrayList<>();
            ArrayList<String> selectedPositions = new ArrayList<>();
            int totalSelected = 0;

            for (SlotItem item : slotList) {
                // Only count and send checkboxes selected by current user
                if (item.isCheckedA && !item.isJoinedA) {
                    selectedSlotNumbers.add(String.valueOf(item.slotNumber));
                    selectedPositions.add("A");
                    totalSelected++;
                }
                if (item.isCheckedB && !item.isJoinedB) {
                    selectedSlotNumbers.add(String.valueOf(item.slotNumber));
                    selectedPositions.add("B");
                    totalSelected++;
                }
                if (item.isCheckedC && !item.isJoinedC) {
                    selectedSlotNumbers.add(String.valueOf(item.slotNumber));
                    selectedPositions.add("C");
                    totalSelected++;
                }
                if (item.isCheckedD && !item.isJoinedD) {
                    selectedSlotNumbers.add(String.valueOf(item.slotNumber));
                    selectedPositions.add("D");
                    totalSelected++;
                }
            }

            if (totalSelected == 0) {
                Toast.makeText(this, "Please select your slot!", Toast.LENGTH_SHORT).show();
            } else {
                Intent intent = new Intent(MatchSlotsActivity.this, MatchJoiningActivity.class);
                intent.putStringArrayListExtra("selectedSlotNumbers", selectedSlotNumbers);
                intent.putStringArrayListExtra("selectedPositions", selectedPositions);
                intent.putExtra("totalSelection", totalSelected);
                intent.putExtra("matchId", matchId);
                intent.putExtra("gamename", gamename);
                intent.putExtra("entryFee", entryFee);
                startActivity(intent);
            }
        });

        checkJoinedPositionBox();
    }

    private void loadSlotList() {
        int divideBy = teamType.equalsIgnoreCase("Solo") ? 1 :
                teamType.equalsIgnoreCase("Duo") ? 2 : 4;

        int rows = (int) (totalPlayer / divideBy);

        slotList = new ArrayList<>();
        for (int i = 1; i <= rows; i++) {
            slotList.add(new SlotItem(i));
        }
    }

    public void checkJoinedPositionBox() {
        Call<ArrayList<Joined_Match_Model>> call = myApi.fetchMatchJoinedUsers(matchId);
        call.enqueue(new Callback<ArrayList<Joined_Match_Model>>() {
            @Override
            public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    for (Joined_Match_Model joined : response.body()) {
                        int slotNo = joined.getSlot_no();
                        String position = joined.getPosition();

                        for (SlotItem item : slotList) {
                            if (item.getSlotNumber() == slotNo) {
                                switch (position) {
                                    case "A":
                                        item.isCheckedA = true;
                                        item.isJoinedA = true;
                                        break;
                                    case "B":
                                        item.isCheckedB = true;
                                        item.isJoinedB = true;
                                        break;
                                    case "C":
                                        item.isCheckedC = true;
                                        item.isJoinedC = true;
                                        break;
                                    case "D":
                                        item.isCheckedD = true;
                                        item.isJoinedD = true;
                                        break;
                                }
                            }
                        }
                    }

                    adapter.notifyDataSetChanged(); // Update checkboxes
                }
            }

            @Override
            public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                Toast.makeText(MatchSlotsActivity.this, "Failed: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }
}
